<?php

/**
 * Author: GPLSAVER
 * Date: 1/10/2016
 * Time: 2:57 PM
 */
if (!function_exists('rfqtk_get_email_order_items')) {
    function rfqtk_get_email_order_items($order, $args = array())
    {
        ob_start();

        $defaults = array(
            'show_sku' => false,
            'show_image' => false,
            'image_size' => array(32, 32),
            'plain_text' => false,
            'sent_to_admin' => false,
            'hide_admin' => false,
        );

        $args = wp_parse_args($args, $defaults);
        $template = $args['plain_text'] ? 'emails/plain/rfqtk-email-order-items.php' : 'emails/rfqtk-email-order-items.php';

        wc_get_template($template, apply_filters('woocommerce_email_order_items_args', array(
            'order' => $order,
            'items' => $order->get_items(),
            'show_download_links' => $order->is_download_permitted() && !$args['sent_to_admin'],
            'show_sku' => $args['show_sku'],
            'show_purchase_note' => $order->is_paid() && !$args['sent_to_admin'],
            'show_image' => $args['show_image'],
            'image_size' => $args['image_size'],
            'plain_text' => $args['plain_text'],
            'sent_to_admin' => $args['sent_to_admin'],
            'hide_admin' => $args['hide_admin'],
        )),'', gpls_woo_rfq_plus_DIR . 'woocommerce/');

        return apply_filters('woocommerce_email_order_items_table', ob_get_clean(), $order);
    }
}



if (!class_exists('WC_Email_RFQ_PLUS')) {
    class WC_Email_RFQ_PLUS
    {


        /**
         * Constructor
         */
        public function __construct()
        {
            // add_action('wp_loaded', array($this, 'gpls_woo_plugins_loaded'), 1000,1);
            // add_action('init', array($this, 'gpls_rfq_register_email'), 10000);

            //add_filter('woocommerce_email_headers', array($this, 'gpls_woo_rfq_add_reply_to_admin_order'), 11, 3);
            $this->gpls_rfq_register_email();

        }


        public function gpls_woo_plugins_loaded()
        {
            // add_filter('woocommerce_email_headers', array($this, 'gpls_woo_rfq_add_reply_to_admin_order'), 11, 3);
        }


        public function gpls_woo_add_resend_quote_sent($actions)
        {

            $ends=gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key),'D');
            if ($ends!=1) {
                $actions['send_rfq'] = __('Resend quote sent email', 'rfqtk');
            }
            $actions['send_rfq_confirm'] = __('Resend quote recieved confirmation', 'rfqtk');

            return $actions;
        }


        public function gpls_woo_resend_order_emails_available($actions)
        {

            $ends=gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key),'D');
            if ($ends!=1) {
                array_push($actions, 'customer_rfq_sent');
            }


            array_push($actions, 'customer_rfq');

            return $actions;
        }

        function gpls_woo_resend_send_quote_sent($order)
        {

            $ends=gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key),'D');
            if ($ends!=1) {
                // Send the admin new order email.
                WC()->payment_gateways();
                WC()->shipping();
                WC()->mailer()->emails['WC_Email_Customer_RFQ_Sent']->trigger($order->get_id(), $order);
                // Note the event.
                $order->add_order_note(__('Quote Sent Email manually sent to customer.', 'rfqtk'), false, true);
                do_action('woocommerce_after_resend_order_email', $order, 'customer_rfq_sent');
                // Change the post saved message.
                add_filter('redirect_post_location', array('WC_Meta_Box_Order_Actions', 'set_email_sent_message'));
            }
        }

        public function gpls_woo_resend_send_rfq_confirm($order)
        {
            // Send the admin new order email.

            WC()->payment_gateways();
            WC()->shipping();
            WC()->mailer()->emails['WC_Email_Customer_RFQ']->trigger($order->get_id(), $order);
            // Note the event.
            $order->add_order_note(__('Quote Received Email manually sent to customer.', 'rfqtk'), false, true);
            do_action('woocommerce_after_resend_order_email', $order, 'customer_rfq');
            // Change the post saved message.
            add_filter('redirect_post_location', array('WC_Meta_Box_Order_Actions', 'set_email_sent_message'));
        }

        public function add_resend_quote_sent($actions)
        {
            $ends=gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key),'D');
            if ($ends!=1) {
                $actions['customer_rfq_sent'] = __('RFQ-ToolKit Quote Sent', 'rfqtk');
            }

            return $actions;
        }

        public function gpls_rfq_register_email()
        {


            add_filter('woocommerce_locate_core_template', array($this, 'gpls_woo_rfq_pay_woocommerce_locate_template'), 1, 4);
            add_filter('woocommerce_locate_template', array($this, 'gpls_woo_rfq_locate_template'), 1, 3);

            add_filter('woocommerce_email_classes', array($this, 'gpls_rfq_setup_new_requests_emails'), 5, 1);
            add_filter('woocommerce_email_actions', array($this, 'gpls_qbb_quote_request_filter_actions'), 1000, 1);

            add_action('woocommerce_order_status_gplsquote-sent', array($this, 'send_transactional_email'), 1000, 2);
            add_action('woocommerce_new_admin_note', array($this, 'send_transactional_email'), 1000, 2);
            add_action('woocommerce_new_gpls_prod_marketing', array($this, 'send_transactional_email'), 1000, 2);


            add_filter('woocommerce_resend_order_emails_available', array($this, 'filter_woocommerce_resend_order_emails_available'), 100, 1);

            //  add_action('woocommerce_order_item_meta_start', array($this, 'gpls_woo_rfq_order_item_attributes_meta_start'), -2, 3);
            //   add_action('woocommerce_order_item_meta_start', array($this, 'gpls_woo_rfq_order_item_custom_fields_meta_start'), -1, 3);


            add_filter('woocommerce_email_headers', array($this, 'gpls_woo_rfq_add_reply_to_admin_order'), 100000, 4);




            add_filter('woocommerce_order_actions', array($this, 'gpls_woo_add_resend_quote_sent'), 9, 1);
            add_action('woocommerce_order_action_send_rfq', array($this, 'gpls_woo_resend_send_quote_sent'), 100, 1);

            add_action('woocommerce_order_action_send_rfq_confirm', array($this, 'gpls_woo_resend_send_rfq_confirm'), 100, 1);
            add_filter('woocommerce_resend_order_emails_available', array($this, 'gpls_woo_resend_order_emails_available'), 100, 1);


            //$from_name = apply_filters( 'woocommerce_email_from_name', get_option( 'woocommerce_email_from_name' ), $this );
            //$from_address, $email );
            //   add_filter('woocommerce_email_from_address', array($this, 'gpls_woo_email_from_address'), 100, 2);

            //$from_name = apply_filters( 'woocommerce_email_from_name', get_option( 'woocommerce_email_from_name' ), $this );
            //$from_address, $email );
            add_filter('woocommerce_email_from_address', array($this, 'gpls_woo_email_from_address'), 100, 2);




        }



        public function gpls_woo_email_from_address($from_address, $email)
        {

            if ($email->id == "customer_rfq_sent") {

                //$order = wc_get_order($email->object->get_id());
                $gpls_woo_rfq_email_sender = trim(get_post_meta($email->object->get_id(), '_gpls_woo_rfq_email_sender', true));
                if (isset($gpls_woo_rfq_email_sender) && $gpls_woo_rfq_email_sender != null
                    && filter_var($gpls_woo_rfq_email_sender, FILTER_VALIDATE_EMAIL)) {
                    $from_address = $gpls_woo_rfq_email_sender;

                }
            }
            return $from_address;
        }


        public function gpls_woo_rfq_pay_woocommerce_locate_template($template, $template_name, $template_path,$id)
        {

            // global $woocommerce;

            $ids = array('new_rfq','customer_rfq','new_pdf_request','admin_note'
            ,'new_vendor_rfq','gpls_prod_marketing','customer_rfq_sent','gpls_admin_upload');

            if(!in_array($id,$ids)){
                return $template;
            }

            $_template = $template;
            if (!$template_path)
                $template_path = WC()->template_url;

            $plugin_path = gpls_woo_rfq_plus_DIR . 'woocommerce/';

            // Look within passed path within the theme - this is priority
            $template = locate_template(
                array(
                    $template_path . $template_name,
                    $template_name
                )
            );

            if (!$template && file_exists($plugin_path . $template_name))
                $template = $plugin_path . $template_name;

            if (!$template)
                $template = $_template;

            return $template;


        }



        public function gpls_woo_rfq_locate_template($template, $template_name, $template_path)
        {

            $template_names = array('admin-note.php','customer-rfq-sent.php','product-marketing.php'
            ,'rfqtk-email-order-items.php','vendor-new-rfq.php',

                'cart-pdf-admin.php',

                'admin-upload-note.php',

                'admin-new-rfq.php','customer-note.php','customer-rfq.php'
            );

            $cart_array= array('proceed-to-checkout-button.php');


            if(substr($template_name, 0, strlen('emails')) === 'emails')
            {
                if(!in_array(str_replace("emails/","",$template_name),$template_names)){

                    return $template;
                }

            }

            else if(substr($template_name, 0, strlen('cart')) === 'cart')
            {
                if(!in_array(str_replace("cart/","",$template_name),$cart_array)){

                    return $template;
                }

            }else{
                $len = strlen('woo-rfq');

                if(substr($template_name, 0, $len) !== 'woo-rfq')
                {

                    return $template;
                }

            }
            $_template = $template;

            if ( ! $template_path )
                $template_path = WC()->template_url;

            $plugin_path  = gpls_woo_rfq_DIR  . 'woocommerce/';

            //
            $template = locate_template(
                array(
                    $template_path . $template_name,
                    $template_name
                )
            );

            if( ! $template && file_exists( $plugin_path . $template_name ) )
                $template = $plugin_path . $template_name;

            if ( ! $template )
                $template = $_template;
            // d($template);
            return $template;
            // Return what we found

        }



//return apply_filters( 'woocommerce_email_headers', $header, $this->id, $this->object, $this );

        public function gpls_woo_rfq_add_reply_to_admin_order($header, $id, $order, $WC_Email)
        {
            $header .= 'Content-Type: text/html' . PHP_EOL;

            if ($id == "customer_rfq_sent") {


                $gpls_woo_rfq_email_replyto = trim(get_post_meta($order->get_id(), '_gpls_woo_rfq_email_reply', true));

                if (isset($gpls_woo_rfq_email_replyto) && $gpls_woo_rfq_email_replyto != null) {
                    $replyto_address = $gpls_woo_rfq_email_replyto;

                    $header .= 'Reply-to: ' . $replyto_address . PHP_EOL;
                }

                $gpls_woo_rfq_email_cc = trim(get_post_meta($order->get_id(), '_gpls_woo_rfq_email_cc', true));

                if (isset($gpls_woo_rfq_email_cc) && $gpls_woo_rfq_email_cc != null) {
                    $cc_address = $gpls_woo_rfq_email_cc;
                    $header .= 'Cc: ' . $cc_address . PHP_EOL;
                }

            }

            $reply_to_admin = trim(get_option('settings_gpls_woo_rfq_admin_email_reply_to', 'no'));

            if ($reply_to_admin == "yes" && ($id == 'new_rfq' || $id == 'admin_note')) {
                $reply_to_email = $order->get_billing_email();

                if ($order && $order->get_billing_email() && ($order->get_billing_first_name() || $order->get_billing_last_name())) {
                    $header .= 'Reply-to: ' . $order->get_billing_first_name() . ' ' . $order->get_billing_last_name() . ' <' . $order->get_billing_email() . ">".PHP_EOL;
                }

            }

            if ($id == "customer_rfq")
            {

                $gpls_woo_rfq_email_new_rfq_cc = get_option('settings_gpls_woo_rfq_email_new_rfq_cc', '');

                if (isset($gpls_woo_rfq_email_new_rfq_cc)) {
                    $gpls_woo_rfq_email_new_rfq_cc =
                        preg_replace('/\.$/', '', $gpls_woo_rfq_email_new_rfq_cc);
                    $array = explode(', ', $gpls_woo_rfq_email_new_rfq_cc);
                    foreach($array as $value) //loop over values
                    {
                        $header .= "CC:".$gpls_woo_rfq_email_new_rfq_cc.PHP_EOL;
                    }

                }
            }

            return $header;
        }




        public function gpls_woo_rfq_order_item_custom_fields_meta_start($item_id, $item, $order)
        {
            try {

                $attribute_array = trim(get_option('settings_gpls_woo_rfq_product_custom_fields', ''));

                if (!isset($attribute_array)) return;

                $attribute_array = explode(',', $attribute_array);

                if (count($attribute_array) == 0 || !is_array($attribute_array)) return;

                $_product = apply_filters('woocommerce_order_item_product', $item->get_product(), $item);

                foreach ($attribute_array as $attrib) {

                    $tmp = get_post_meta($_product->get_id(), $attrib, true);

                    if ($tmp != '') {

                        if (is_array($tmp)) {
                            //  echo '<br/>'.$attrib.': ' . '<br/>';
                            // gpls_woo_rfqtk_recursive($tmp);
                        } else {

                            echo '<br/>' . $attrib . ': ' . $tmp;
                        }

                    }

                }
            } catch (Exception $ex) {

            }


        }


        public
        function gpls_woo_rfq_order_item_attributes_meta_start($item_id, $item, $order)
        {

            try {


                $attribute_array = trim(get_option('settings_gpls_woo_rfq_product_attributes', ''));

                if (!isset($attribute_array)) return;

                $attribute_array = explode(',', $attribute_array);

                if (count($attribute_array) == 0 || !is_array($attribute_array)) return;

                $_product = apply_filters('woocommerce_order_item_product', $item->get_product(), $item);

                $attributes = $_product->get_attributes();

                echo '<br /><br />';

                if (!$attributes) {
                    return;
                }

                foreach ($attributes as $attribute) {
                    if (!is_a($attribute, 'WC_Product_Attribute')) {
                        continue;
                    }

                    //echo wc_attribute_label($attribute->get_name()).' '.$attribute->get_name().'<br />';
                    if (!in_array(wc_attribute_label($attribute->get_name()), $attribute_array) && !in_array(($attribute->get_name()), $attribute_array)) continue;
                    $out = '<span class="gpls_prod_attri"></span>' . wc_attribute_label($attribute->get_name()) . ': ';
                    $values = array();

                    if ($attribute->is_taxonomy()) {
                        $attribute_taxonomy = $attribute->get_taxonomy_object();
                        $attribute_values = wc_get_product_terms($_product->get_id(), $attribute->get_name(), array('fields' => 'all'));

                        foreach ($attribute_values as $attribute_value) {
                            $value_name = esc_html($attribute_value->name);

                            if ($attribute_taxonomy->attribute_public) {
                                $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                            } else {
                                $values[] = $value_name;
                            }
                        }
                    } else {
                        $values = $attribute->get_options();

                        foreach ($values as &$value) {
                            $value = esc_html($value);
                        }
                    }
                    $out .= apply_filters('woocommerce_attribute', (wptexturize(implode(', ', $values))), $attribute, $values);
                    echo $out . '</span><br />';


                }

            } catch (Exception $ex) {

            }

        }

        public
        function filter_woocommerce_resend_order_emails_available($array)
        {
            // make filter magic happen here...
            array_push($array, 'customer_rfq_sent');
            return $array;
        }

        public
        function send_transactional_email($args = array(), $message = '')
        {
            global $woocommerce;

            $woocommerce->mailer();

            do_action(current_filter() . '_notification', $args, $message);
        }

        /**
         * Register "woocommerce_order_status_pending_to_quote" as an email trigger
         */

        public
        function gpls_qbb_quote_request_filter_actions($actions)
        {
            // $actions[] = "woocommerce_new_quote_created";
            return $actions;
        }

        public
        function gpls_rfq_setup_new_requests_emails($emails)
        {

            $ends=gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key),'D');
            if ($ends==1) {
                return $emails;
            }
            $emails['WC_Email_Customer_RFQ_Sent'] = include(gpls_woo_rfq_plus_DIR . 'includes/emails/rfq-sent.php');
            $emails['WC_Email_Admin_Note'] = include(gpls_woo_rfq_plus_DIR . 'includes/emails/admin-note.php');
            $emails['WC_Email_Product_Marketing'] = include(gpls_woo_rfq_plus_DIR . 'includes/emails/product-marketing.php');

            if (class_exists('WCMp'))
            {
                $emails['WC_Email_Vendor_New_RFQ'] = include(gpls_woo_rfq_plus_DIR . 'includes/emails/class-wc-email-vendor-new-rfq.php');
            }


            return $emails;
        }


    }
}

$wc_email_rfq_plus = new WC_Email_RFQ_PLUS();


?>