<?php
/**
 * Quote Sent email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-rfq-sent.php.
 *
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

$show_prices=true;
$text_align  = is_rtl() ? 'right' : 'left';
$margin_side = is_rtl() ? 'left' : 'right';

add_filter('woocommerce_email_order_items_args', 'filter_gpls_woo_rfq_add_show_prices_to_wc_emails', 100, 1);

$of = new WC_Order_Factory();

$order = $of::get_order($order->get_id());

do_action('woocommerce_email_header', $email_heading,$email);

?>

<?php if($content_intro !="")echo '<p>'.$content_intro.'</p>'; ?>

<?php do_action('rfqtk_email_proposal', $order, $sent_to_admin, $plain_text); ?>

<?php

$include_pay_link="no";

$include_pay_link = get_post_meta($order->get_id(), '_include_proposal_pay_link', true);

?>
<ul>

<?php if (  $include_pay_link === "yes") : ?>
    <li>
    <?php printf( __( 'If you wish to pay please use the following link: %s', 'rfqtk' ) ,
        '<a  class="rfq_pay_link" href="' . esc_url( $order->get_checkout_payment_url() ) . '">' . __( 'Pay', 'rfqtk' ) . '</a>. ' ); ?>
    </li>
<?php endif; ?>

<?php

$include_accept_link="no";

$include_accept_link = get_post_meta($order->get_id(), '_include_accept_link', true);

$include_accept_link_url = home_url().'/customer-respond/?respond_to_offer=true&accept_offer=true&id='.$order->get_id().'&key='.$order->get_order_key();
?>

<?php if (  $include_accept_link=="yes" ) : ?>
<!--<li>
    <?php /*printf( __( 'You can accept this offer by clicking: %s', 'rfqtk' ) , '<a href="' . esc_url( $include_accept_link_url ) . '">' . __( 'Accept Offer', 'rfqtk' ) . '</a>.' ); */?>
</li>-->

    <li>
        <?php echo __('You can accept this offer by clicking:', 'rfqtk' )  ?>
        <?php echo '<a class="rfq_accept_link" href="' . esc_url( $include_accept_link_url ) . '">' . __( 'Accept Offer', 'rfqtk' ) . '</a>.'  ?>
    </li>

    <?php endif; ?>

    <?php
    $include_respond_link="no";

    $include_respond_link = get_post_meta($order->get_id(), '_include_respond_link', true);

    $include_respond_link_url = home_url().'/customer-respond/?respond_to_offer=true&id='.$order->get_id().'&key='.$order->get_order_key();
    ?>

    <?php if (  $include_respond_link=="yes" ) : ?>
        <li>
            <?php printf( ''.__( 'You can respond to this offer by clicking: %s', 'rfqtk' ) , '<a class="rfq_respond_link" href="' . esc_url( $include_respond_link_url ) . '">' . __( 'Respond', 'rfqtk' ) . '</a>.' ); ?>
        </li>
    <?php endif; ?>

</ul>


<?php do_action('woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email ); ?>

<h2><?php printf(__('Request #%s', 'rfqtk'), $order->get_order_number()); ?></h2>

<table class="td" cellspacing="0" cellpadding="6"
       style="width: 90%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
    <thead>
    <tr>
        <th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php _e('Product', 'rfqtk'); ?></th>
        <th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php _e('Quantity', 'rfqtk'); ?></th>
        <th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php _e('Price', 'rfqtk'); ?></th>

    </tr>
    </thead>
    <tbody>

    <?php

    ?>

    <?php

    echo wc_get_email_order_items($order,array(
        'items' =>$order->get_items(),
        'show_sku' => true,
        'show_image' => true,
        'image_size' => array(128, 128),
        'plain_text' => $plain_text,
        'show_prices' => true
    )); ?>

    </tbody>
    <?php

    ?>
    <tfoot>
            <?php
            if ($totals = $order->get_order_item_totals()) {
                $i = 0;
                foreach ($totals as $total) {
                    $i++;
                    ?>
                    <tr>
                    <th class="td" scope="row" colspan="2"
                        style="text-align:left; <?php if ($i == 1) echo 'border-top-width: 4px;'; ?>"><?php echo $total['label']; ?></th>
                    <td class="td"
                        style="text-align:left; <?php if ($i == 1) echo 'border-top-width: 4px;'; ?>"><?php echo $total['value']; ?></td>
                    </tr><?php
                }
            }
            ?>

    </tfoot>
</table>

<?php

?>



<?php do_action('woocommerce_email_after_order_table', $order, $sent_to_admin, $plain_text,$email); ?>

<?php do_action('woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text,$email); ?>

<?php do_action('woocommerce_email_confirmation_messages', $order, $sent_to_admin, $plain_text); ?>

<?php do_action( 'woocommerce_customer_email_order_meta', $order, $sent_to_admin, $plain_text,$email); ?>


<?php


//$c = new WC_Emails();
//require_once(WC()->plugin_path() . '/includes/emails/class-wc-email.php');
//require_once(WC()->plugin_path() . '/includes/class-wc-emails.php');

//$email = WC_Emails::instance();

?>

<?php  do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email ); ?>
<?php
if ( $additional_content ) {
    echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
}
?>
<?php   do_action('woocommerce_email_footer', $email); ?>

