<?php
/**
 */
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly 
global $WCMp;
$text_align  = is_rtl() ? 'right' : 'left';
$margin_side = is_rtl() ? 'left' : 'right';

do_action('woocommerce_email_header', $email_heading,$email);


$show_prices=true;

gpls_woo_rfq_remove_filters_normal_checkout();
gpls_woo_rfq_remove_filters();

?>

<p><?php printf(__('A new Quote Request was received from %s. Their request is as follows:', 'rfqtk'), $order->get_billing_first_name() . ' ' . $order->get_billing_last_name()); ?></p>
<h2><a class="link" href="<?php echo admin_url( 'post.php?post=' . $order->get_id() . '&action=edit' ); ?>"><?php printf( __( 'Order #%s', 'rfqtk'), $order->get_order_number() ); ?></a> (<?php printf( '<time datetime="%s">%s</time>', date_i18n( 'c', strtotime( $order->get_date_created() ) ), date_i18n( wc_date_format(), strtotime( $order->get_date_created() ) ) ); ?>)</h2>

<?php do_action('woocommerce_email_before_order_table', $order, true, false, $email ); ?>
<table cellspacing="0" cellpadding="6" style="width: 100%; border: 1px solid #eee;" border="1" bordercolor="#eee">
    <thead>
    <tr>
        <th scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>; border: 1px solid #eee;"><?php _e('Product', 'rfqtk'); ?></th>
        <th scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>; border: 1px solid #eee;"><?php _e('Quantity', 'rfqtk'); ?></th>
        <th scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>; border: 1px solid #eee;"><?php _e('Price', 'rfqtk'); ?></th>
    </tr>
    </thead>
    <tbody>
    <?php
    $vendor = new WCMp_Vendor(absint($vendor_id));
    // $vendor_items_dtl = $vendor->vendor_order_item_table($order, $vendor_id);
    // echo $vendor_items_dtl;
    global $WCMp;
    global $total_cost;
    $total_cost=0;
    // require_once ( 'class-wcmp-calculate-commission.php' );
    // $commission_obj = new WCMp_Calculate_Commission();
    $order_id=$order->get_id();
    $item_dtl = array();
    $order = new WC_Order($order_id);
    if ($order) {
        $items = $order->get_items('line_item');
        if ($items) {
            foreach ($items as $item_id => $item) {
                $product_id = wc_get_order_item_meta($item_id, '_product_id', true);

                if ($product_id) {
                    if ($vendor_id > 0) {
                        $product_vendors = get_wcmp_product_vendors($product_id);
                        if (isset($product_vendors) && $product_vendors->term_id == $vendor_id) {
                            $item_dtl[$item_id] = $item;
                        }
                    }
                }
            }
        }
    }
    $vendor_items = $item_dtl;

    foreach ($vendor_items as $item_id => $item) {
        $_product = apply_filters('wcmp_woocommerce_order_item_product', $item->get_product() , $item);
        ?>
        <tr class="">
            <td scope="col" style="text-align:left; border: 1px solid #eee;" class="product-name">
                <?php
                if ($_product && !$_product->is_visible()) {
                    echo apply_filters('wcmp_woocommerce_order_item_name', $item['name'], $item);
                } else {
                    echo apply_filters('woocommerce_order_item_name', sprintf('<a href="%s">%s</a>', get_permalink($item['product_id']), $item['name']), $item);
                }
                wc_display_item_meta($item);
                ?>
            </td>
            <td scope="col" style="text-align:left; border: 1px solid #eee;">
                <?php
                echo $item['qty'];
                ?>
            </td>
            <td scope="col" style="text-align:left; border: 1px solid #eee;">
                <?php

                $variation_id = 0;
                if (isset($item['variation_id']) && !empty($item['variation_id'])) {
                    $variation_id = $item['variation_id'];
                }
                $product_id = $item['product_id'];

                $product = wc_get_product($product_id);
                //$commission_amount = get_wcmp_vendor_order_amount(array('order_id' => $order->get_id(), 'product_id' => $product_id, 'variation_id' => $variation_id, 'order_item_id' => $item_id));
                /*if ($is_ship) {
                    echo $order->get_formatted_line_subtotal($item);
                } else {
                    echo wc_price($product->get_price());
                }*/
                $total_cost=$total_cost+$product->get_price();
                echo $product->get_price();

                ?>
            </td>
        </tr>
        <?php
    }
    ?>
    </tbody>
</table>
<?php
$vendor = new WCMp_Vendor(absint($vendor_id));
$show_cust_order_calulations_field = apply_filters('show_cust_order_calulations_field', true);

global $WCMp;
global $total_cost;

if ($WCMp->vendor_caps->vendor_capabilities_settings('show_cust_order_calulations') && $show_cust_order_calulations_field) {
    ?>
    <table cellspacing="0" cellpadding="6" style="width: 100%; border: 1px solid #eee;" border="1" bordercolor="#eee">
        <?php

        $totals=array();
        $amount=array();

        if ($vendor_id) {
            $args['vendor_id'] = $vendor_id;
        }
        if (isset($args['vendor_id'])) {
            $vendor_id = $args['vendor_id'];
        }
        if (!isset($args['is_trashed'])) {
            $args['is_trashed'] = '';
        }
        $vendor_orders_in_order = get_wcmp_vendor_orders($args);

        if (!empty($vendor_orders_in_order)) {
            $shipping_amount = array_sum(wp_list_pluck($vendor_orders_in_order, 'shipping'));
            $tax_amount = array_sum(wp_list_pluck($vendor_orders_in_order, 'tax'));
            $shipping_tax_amount = array_sum(wp_list_pluck($vendor_orders_in_order, 'shipping_tax_amount'));
            $commission_amount = 0;
            $total = $total_cost + $shipping_amount + $tax_amount + $shipping_tax_amount;
            //$total =
        } else {
            $shipping_amount = 0;
            $tax_amount = 0;
            $shipping_tax_amount = 0;
            $commission_amount = 0;
            $total = 0;
        }
        if ( $WCMp && $vendor_id) {
            $amount = array(
                'commission_amount' => $commission_amount,
            );
            if ($WCMp->vendor_caps->vendor_payment_settings('give_shipping') && !get_user_meta($vendor_id, '_vendor_give_shipping', true)) {
                $amount['shipping_amount'] = $shipping_amount;
            } else {
                $amount['shipping_amount'] = 0;
            }
            if ($WCMp->vendor_caps->vendor_payment_settings('give_tax') && $WCMp->vendor_caps->vendor_payment_settings('give_shipping') && !get_user_meta($vendor_id, '_vendor_give_shipping', true) && !get_user_meta($vendor_id, '_vendor_give_tax', true)) {
                $amount['tax_amount'] = $tax_amount;
                $amount['shipping_tax_amount'] = $shipping_tax_amount;
            } else if ($WCMp->vendor_caps->vendor_payment_settings('give_tax') && !get_user_meta($vendor_id, '_vendor_give_tax', true)) {
                $amount['tax_amount'] = $tax_amount;
                $amount['shipping_tax_amount'] = 0;
            } else {
                $amount['tax_amount'] = 0;
                $amount['shipping_tax_amount'] = 0;
            }
            $amount['total'] = $total_cost + $amount['shipping_amount'] + $amount['tax_amount'] + $amount['shipping_tax_amount'];
            $totals= $amount;
        } else {
            $totals = array(
                'commission_amount' => 0,
                'shipping_amount' => $shipping_amount,
                'tax_amount' => $tax_amount,
                'shipping_tax_amount' => $shipping_tax_amount,
                'total' => $total_cost+$tax_amount+$shipping_tax_amount
            );
        }
        $totals =  array(
            'commission_subtotal' => array(
                'label' => __('Commission Subtotal:', 'rfqtk'),
                'value' => wc_price(0)
            ),
            'tax_subtotal' => array(
                'label' => __('Tax Subtotal:', 'rfqtk'),
                'value' => wc_price($amount['tax_amount'] + $amount['shipping_tax_amount'])
            ),
            'shipping_subtotal' => array(
                'label' => __('Shipping Subtotal:', 'rfqtk'),
                'value' => wc_price($amount['shipping_amount'])
            ),
            'total' => array(
                'label' => __('Total:', 'rfqtk'),
                'value' => wc_price($total_cost+$amount['tax_amount'] + $amount['shipping_tax_amount']+$amount['shipping_amount'])
            )
        );

        if ($totals ) {
            foreach ($totals as $total_key => $total) {
                ?><tr>
                <th scope="row" colspan="2" style="text-align:left; border: 1px solid #eee;"><?php echo $total['label']; ?></th>
                <td style="text-align:left; border: 1px solid #eee;"><?php echo $total['value']; ?></td>
                </tr><?php
            }
            $total_cost=0;
        }
        ?>
    </table>
    <?php
}
$show_cust_add_field = apply_filters('show_cust_add_field', true);
$show_customer_detail = $WCMp->vendor_caps->vendor_capabilities_settings('show_cust_add');
if ($show_customer_detail && $show_cust_add_field) {
    ?>
    <h2><?php _e('Customer Details', 'rfqtk'); ?></h2>
    <?php if ($order->get_billing_email()) { ?>
        <p><strong><?php _e('Customer Name:', 'rfqtk'); ?></strong> <?php echo $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(); ?></p>
        <p><strong><?php _e('Email:', 'rfqtk'); ?></strong> <?php echo $order->get_billing_email(); ?></p>
    <?php } ?>
    <?php if ($order->get_billing_phone()) { ?>
        <p><strong><?php _e('Telephone:', 'rfqtk'); ?></strong> <?php echo $order->get_billing_phone(); ?></p>
        <?php
    }
}
$show_cust_billing_add_field = apply_filters('show_cust_billing_add_field', true);
$show_cust_shipping_add_field = apply_filters('show_cust_shipping_add_field', true);
$show_cust_billing_add = $WCMp->vendor_caps->vendor_capabilities_settings('show_cust_billing_add');
$show_cust_shipping_add = $WCMp->vendor_caps->vendor_capabilities_settings('show_cust_shipping_add');
if ($show_cust_billing_add && $show_cust_billing_add_field) {
    ?>
    <table cellspacing="0" cellpadding="0" style="width: 100%; vertical-align: top;" border="0">
        <tr>
            <td valign="top" width="50%">
                <h3><?php _e('Billing Address', 'rfqtk'); ?></h3>
                <p><?php echo $order->get_formatted_billing_address(); ?></p>
            </td>
        </tr>
    </table>
<?php }
?>

<?php if ($show_cust_shipping_add && $show_cust_shipping_add_field) { ?>
    <?php if (( $shipping = $order->get_formatted_shipping_address())) { ?>
        <table cellspacing="0" cellpadding="0" style="width: 100%; vertical-align: top;" border="0">
            <tr>
                <td valign="top" width="50%">
                    <h3><?php _e('Shipping Address', 'rfqtk'); ?></h3>
                    <p><?php echo $shipping; ?></p>
                </td>
            </tr>
        </table>
        <?php
    }
}
?>



<?php do_action('wcmp_email_footer', $email ); ?>


