<?php
namespace Aws\AppMesh;

use Aws\AwsClient;

/**
 * This client is used to interact with the **AWS App Mesh** service.
 * @method \Aws\Result createMesh(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createMeshAsync(array $args = [])
 * @method \Aws\Result createRoute(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createRouteAsync(array $args = [])
 * @method \Aws\Result createVirtualNode(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createVirtualNodeAsync(array $args = [])
 * @method \Aws\Result createVirtualRouter(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createVirtualRouterAsync(array $args = [])
 * @method \Aws\Result deleteMesh(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteMeshAsync(array $args = [])
 * @method \Aws\Result deleteRoute(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteRouteAsync(array $args = [])
 * @method \Aws\Result deleteVirtualNode(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVirtualNodeAsync(array $args = [])
 * @method \Aws\Result deleteVirtualRouter(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVirtualRouterAsync(array $args = [])
 * @method \Aws\Result describeMesh(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeMeshAsync(array $args = [])
 * @method \Aws\Result describeRoute(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeRouteAsync(array $args = [])
 * @method \Aws\Result describeVirtualNode(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeVirtualNodeAsync(array $args = [])
 * @method \Aws\Result describeVirtualRouter(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeVirtualRouterAsync(array $args = [])
 * @method \Aws\Result listMeshes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listMeshesAsync(array $args = [])
 * @method \Aws\Result listRoutes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listRoutesAsync(array $args = [])
 * @method \Aws\Result listVirtualNodes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listVirtualNodesAsync(array $args = [])
 * @method \Aws\Result listVirtualRouters(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listVirtualRoutersAsync(array $args = [])
 * @method \Aws\Result updateRoute(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateRouteAsync(array $args = [])
 * @method \Aws\Result updateVirtualNode(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateVirtualNodeAsync(array $args = [])
 * @method \Aws\Result updateVirtualRouter(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateVirtualRouterAsync(array $args = [])
 * @method \Aws\Result createGatewayRoute(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise createGatewayRouteAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result createVirtualGateway(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise createVirtualGatewayAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result createVirtualService(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise createVirtualServiceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result deleteGatewayRoute(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteGatewayRouteAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result deleteVirtualGateway(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVirtualGatewayAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result deleteVirtualService(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVirtualServiceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result describeGatewayRoute(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGatewayRouteAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result describeVirtualGateway(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise describeVirtualGatewayAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result describeVirtualService(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise describeVirtualServiceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result listGatewayRoutes(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise listGatewayRoutesAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result listTagsForResource(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result listVirtualGateways(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise listVirtualGatewaysAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result listVirtualServices(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise listVirtualServicesAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result tagResource(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result untagResource(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result updateGatewayRoute(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise updateGatewayRouteAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result updateMesh(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise updateMeshAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result updateVirtualGateway(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise updateVirtualGatewayAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \Aws\Result updateVirtualService(array $args = []) (supported in versions 2019-01-25)
 * @method \WPLab\GuzzeHttp\Promise\Promise updateVirtualServiceAsync(array $args = []) (supported in versions 2019-01-25)
 */
class AppMeshClient extends AwsClient {}
