<?php
namespace Aws\CostExplorer;

use Aws\AwsClient;

/**
 * This client is used to interact with the **AWS Cost Explorer Service** service.
 * @method \Aws\Result createAnomalyMonitor(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createAnomalyMonitorAsync(array $args = [])
 * @method \Aws\Result createAnomalySubscription(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createAnomalySubscriptionAsync(array $args = [])
 * @method \Aws\Result createCostCategoryDefinition(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createCostCategoryDefinitionAsync(array $args = [])
 * @method \Aws\Result deleteAnomalyMonitor(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteAnomalyMonitorAsync(array $args = [])
 * @method \Aws\Result deleteAnomalySubscription(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteAnomalySubscriptionAsync(array $args = [])
 * @method \Aws\Result deleteCostCategoryDefinition(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteCostCategoryDefinitionAsync(array $args = [])
 * @method \Aws\Result describeCostCategoryDefinition(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeCostCategoryDefinitionAsync(array $args = [])
 * @method \Aws\Result getAnomalies(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAnomaliesAsync(array $args = [])
 * @method \Aws\Result getAnomalyMonitors(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAnomalyMonitorsAsync(array $args = [])
 * @method \Aws\Result getAnomalySubscriptions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAnomalySubscriptionsAsync(array $args = [])
 * @method \Aws\Result getCostAndUsage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCostAndUsageAsync(array $args = [])
 * @method \Aws\Result getCostAndUsageWithResources(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCostAndUsageWithResourcesAsync(array $args = [])
 * @method \Aws\Result getCostCategories(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCostCategoriesAsync(array $args = [])
 * @method \Aws\Result getCostForecast(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCostForecastAsync(array $args = [])
 * @method \Aws\Result getDimensionValues(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDimensionValuesAsync(array $args = [])
 * @method \Aws\Result getReservationCoverage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getReservationCoverageAsync(array $args = [])
 * @method \Aws\Result getReservationPurchaseRecommendation(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getReservationPurchaseRecommendationAsync(array $args = [])
 * @method \Aws\Result getReservationUtilization(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getReservationUtilizationAsync(array $args = [])
 * @method \Aws\Result getRightsizingRecommendation(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getRightsizingRecommendationAsync(array $args = [])
 * @method \Aws\Result getSavingsPlansCoverage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSavingsPlansCoverageAsync(array $args = [])
 * @method \Aws\Result getSavingsPlansPurchaseRecommendation(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSavingsPlansPurchaseRecommendationAsync(array $args = [])
 * @method \Aws\Result getSavingsPlansUtilization(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSavingsPlansUtilizationAsync(array $args = [])
 * @method \Aws\Result getSavingsPlansUtilizationDetails(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSavingsPlansUtilizationDetailsAsync(array $args = [])
 * @method \Aws\Result getTags(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getTagsAsync(array $args = [])
 * @method \Aws\Result getUsageForecast(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getUsageForecastAsync(array $args = [])
 * @method \Aws\Result listCostAllocationTags(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listCostAllocationTagsAsync(array $args = [])
 * @method \Aws\Result listCostCategoryDefinitions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listCostCategoryDefinitionsAsync(array $args = [])
 * @method \Aws\Result listTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \Aws\Result provideAnomalyFeedback(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise provideAnomalyFeedbackAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result updateAnomalyMonitor(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateAnomalyMonitorAsync(array $args = [])
 * @method \Aws\Result updateAnomalySubscription(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateAnomalySubscriptionAsync(array $args = [])
 * @method \Aws\Result updateCostAllocationTagsStatus(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateCostAllocationTagsStatusAsync(array $args = [])
 * @method \Aws\Result updateCostCategoryDefinition(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateCostCategoryDefinitionAsync(array $args = [])
 */
class CostExplorerClient extends AwsClient {}
